/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.fake;

import customskinloader.fake.FakeSkinBuffer;
import customskinloader.fake.itf.FakeInterfaceManager;
import customskinloader.fake.texture.FakeBufferedImage;
import customskinloader.fake.texture.FakeImage;
import customskinloader.utils.MinecraftUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.resources.ResourceLocation;

public class FakeCapeBuffer
extends FakeSkinBuffer {
    private static final ResourceLocation TEXTURE_ELYTRA = new ResourceLocation("textures/entity/elytra.png");
    private static int loadedGlobal = 0;
    private static FakeImage elytraImage;
    private int loaded = 0;
    private double ratioX = -1.0;
    private double ratioY = -1.0;
    private ResourceLocation location;
    private String type = null;

    private static FakeImage loadElytra(FakeImage originalImage) {
        ++loadedGlobal;
        try {
            InputStream is = FakeInterfaceManager.IResource_getInputStream(FakeInterfaceManager.IResourceManager_getResource(FakeInterfaceManager.Minecraft_getResourceManager(Minecraft.m_91087_()), TEXTURE_ELYTRA).get());
            if (is != null) {
                FakeImage image = originalImage.createImage(is);
                if (image.getWidth() % 64 != 0 || image.getHeight() % 32 != 0) {
                    return elytraImage;
                }
                image = FakeCapeBuffer.resetImageFormat(image, 22, 0, 46, 22);
                return image;
            }
        }
        catch (IOException | NoSuchElementException exception) {
            // empty catch block
        }
        return null;
    }

    public FakeCapeBuffer(ResourceLocation location) {
        this.location = location;
    }

    @Override
    public FakeImage parseUserSkin(FakeImage image) {
        if (image == null) {
            return null;
        }
        this.image = image;
        if (this.loaded == loadedGlobal) {
            elytraImage = FakeCapeBuffer.loadElytra(image);
        }
        this.loaded = loadedGlobal;
        if (elytraImage != null) {
            if (this.ratioX < 0.0) {
                this.ratioX = (double)this.image.getWidth() / 64.0;
            }
            if (this.ratioY < 0.0) {
                this.ratioY = (double)this.image.getHeight() / 32.0;
            }
            if (this.type == null) {
                this.type = this.judgeType();
            }
            if ("cape".equals(this.type)) {
                this.image = FakeCapeBuffer.resetImageFormat(this.image, 0, 0, 22, 17);
                this.attachElytra(elytraImage);
                if (this.image instanceof FakeBufferedImage) {
                    this.refreshTexture((FakeBufferedImage)this.image);
                }
            }
        }
        return this.image;
    }

    @Override
    public String judgeType() {
        if (this.image != null && elytraImage != null) {
            Predicate predicate = (Predicate)EQU_BG.apply(this.image.getRGBA(this.image.getWidth() - 1, this.image.getHeight() - 1));
            return this.withElytraPixels((x, y) -> !predicate.test(this.image.getRGBA((int)x, (int)y)), "elytra", "cape");
        }
        return "cape";
    }

    private void attachElytra(FakeImage elytraImage) {
        if (this.image != null) {
            int capeW = this.image.getWidth();
            int capeH = this.image.getHeight();
            int elytraW = elytraImage.getWidth();
            int elytraH = elytraImage.getHeight();
            if (capeW < elytraW) {
                this.image = FakeCapeBuffer.scaleImage(this.image, true, (double)elytraW / (double)capeW, 1.0, (double)capeW / 64.0, (double)capeH / 32.0, elytraW, capeH, 0, 0, 22, 17);
                capeW = elytraW;
            }
            if (capeH < elytraH) {
                this.image = FakeCapeBuffer.scaleImage(this.image, true, 1.0, (double)elytraH / (double)capeH, (double)capeW / 64.0, (double)capeH / 32.0, capeW, elytraH, 0, 0, 22, 17);
                capeH = elytraH;
            }
            if (elytraW < capeW) {
                elytraImage = FakeCapeBuffer.scaleImage(elytraImage, false, (double)capeW / (double)elytraW, 1.0, (double)elytraW / 64.0, (double)elytraH / 32.0, capeW, elytraH, 22, 0, 46, 22);
                elytraW = capeW;
            }
            if (elytraH < capeH) {
                elytraImage = FakeCapeBuffer.scaleImage(elytraImage, false, 1.0, (double)capeH / (double)elytraH, (double)elytraW / 64.0, (double)elytraH / 32.0, elytraW, capeH, 22, 0, 46, 22);
                elytraH = capeH;
            }
            this.ratioX = (double)capeW / 64.0;
            this.ratioY = (double)capeH / 32.0;
            FakeImage finalElytraImage = elytraImage;
            this.withElytraPixels((x, y) -> {
                this.image.setRGBA((int)x, (int)y, finalElytraImage.getRGBA((int)x, (int)y));
                return false;
            }, null, null);
        }
    }

    private <R> R withElytraPixels(BiPredicate<Integer, Integer> predicate, R returnValue, R defaultReturnValue) {
        int startX = (int)Math.ceil(22.0 * this.ratioX);
        int endX = (int)Math.ceil(46.0 * this.ratioX);
        int startY = (int)Math.ceil(0.0 * this.ratioY);
        int endY = (int)Math.ceil(22.0 * this.ratioY);
        int excludeX0 = (int)Math.ceil(24.0 * this.ratioX);
        int excludeX1 = (int)Math.ceil(44.0 * this.ratioX);
        int excludeY = (int)Math.ceil(2.0 * this.ratioY);
        for (int x = startX; x < endX; ++x) {
            for (int y = startY; y < endY; ++y) {
                if (y < excludeY && (x < excludeX0 || x >= excludeX1) || !predicate.test(x, y)) continue;
                return returnValue;
            }
        }
        return defaultReturnValue;
    }

    private void refreshTexture(FakeBufferedImage image) {
        ITextureObject textureObj = MinecraftUtil.getTextureManager().func_110581_b(this.location);
        if (textureObj != null) {
            FakeInterfaceManager.ThreadDownloadImageData_resetNewBufferedImage(textureObj, image.getImage());
        }
    }

    private static FakeImage resetImageFormat(FakeImage image, int startX, int startY, int endX, int endY) {
        if (image != null) {
            int width = image.getWidth();
            int height = image.getHeight();
            image = FakeCapeBuffer.scaleImage(image, true, 1.0, 1.0, (double)width / 64.0, (double)height / 32.0, width, height, startX, startY, endX, endY);
        }
        return image;
    }

    private static FakeImage scaleImage(FakeImage image, boolean closeOldImage, double scaleWidth, double scaleHeight, double ratioX, double ratioY, int width, int height, int startX, int startY, int endX, int endY) {
        FakeImage newImage = image.createImage(width, height);
        startX = (int)((double)startX * ratioX);
        endX = (int)((double)endX * ratioX);
        startY = (int)((double)startY * ratioY);
        endY = (int)((double)endY * ratioY);
        int x0 = (int)((double)startX * scaleWidth);
        int x1 = (int)((double)(startX + 1) * scaleWidth);
        int dx0 = x1 - x0;
        for (int x = startX; x < endX; ++x) {
            int y0 = (int)((double)startY * scaleHeight);
            int y1 = (int)((double)(startY + 1) * scaleHeight);
            int dy0 = y1 - y0;
            for (int y = startY; y < endY; ++y) {
                int rgba = image.getRGBA(x, y);
                for (int dx = 0; dx < dx0; ++dx) {
                    for (int dy = 0; dy < dy0; ++dy) {
                        newImage.setRGBA(x0 + dx, y0 + dy, rgba);
                    }
                }
                y0 = y1;
                y1 = (int)((double)(y + 2) * scaleHeight);
                dy0 = y1 - y0;
            }
            x0 = x1;
            x1 = (int)((double)(x + 2) * scaleWidth);
            dx0 = x1 - x0;
        }
        if (closeOldImage) {
            image.close();
        }
        return newImage;
    }
}

